/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.jei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.BasinBlazeBurnerRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.processing.basin.BasinRecipe;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.processing.recipe.HeatCondition;
import com.zurrtum.create.content.processing.recipe.ProcessingOutput;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_8786;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public abstract class BasinCategory<T extends BasinRecipe>
extends CreateCategory<class_8786<T>> {
    public int getHeight() {
        return 103;
    }

    public static void addIngredientSlots(IRecipeLayoutBuilder builder, BasinRecipe recipe) {
        List<SizedIngredient> ingredients = recipe.ingredients();
        List<FluidIngredient> fluidIngredients = recipe.fluidIngredients();
        int size = ingredients.size() + fluidIngredients.size();
        int xOffset = size < 3 ? 12 + (3 - size) * 19 / 2 : 12;
        int yOffset = size <= 9 ? 51 : 60;
        int i = 0;
        for (SizedIngredient ingredient : ingredients) {
            builder.addInputSlot(xOffset + i % 3 * 19, yOffset - i / 3 * 19).setBackground((IDrawable)SLOT, -1, -1).addItemStacks(BasinCategory.getStacks(ingredient));
            ++i;
        }
        for (FluidIngredient fluidIngredient : fluidIngredients) {
            BasinCategory.addFluidSlot(builder, xOffset + i % 3 * 19, yOffset - i / 3 * 19, fluidIngredient).setBackground((IDrawable)SLOT, -1, -1);
            ++i;
        }
    }

    public static void addResultSlots(IRecipeLayoutBuilder builder, List<ProcessingOutput> results, int i, int end, int y, boolean isOddSize) {
        for (ProcessingOutput result : results) {
            int xPosition = isOddSize && i == end ? 142 : (i % 2 == 0 ? 132 : 151);
            int yPosition = -19 * (i / 2) + y;
            BasinCategory.addChanceSlot(builder, xPosition, yPosition, result);
            ++i;
        }
    }

    public static void addFluidResultSlots(IRecipeLayoutBuilder builder, List<FluidStack> fluidResults, int i, int end, int y, boolean isOddSize) {
        for (FluidStack fluidResult : fluidResults) {
            int xPosition = isOddSize && i == end ? 142 : (i % 2 == 0 ? 132 : 151);
            int yPosition = -19 * (i / 2) + y;
            BasinCategory.addFluidSlot(builder, xPosition, yPosition, fluidResult).setBackground((IDrawable)SLOT, -1, -1);
            ++i;
        }
    }

    public static void addHeatSlots(IRecipeLayoutBuilder builder, BasinRecipe recipe) {
        HeatCondition requiredHeat = recipe.heat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 134, 81).add((class_1935)AllItems.BLAZE_BURNER);
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            builder.addSlot(RecipeIngredientRole.CRAFTING_STATION, 153, 81).add((class_1935)AllItems.BLAZE_CAKE);
        }
    }

    public static void drawBackground(BasinRecipe recipe, class_332 graphics, int size) {
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 136, (size <= 4 ? 32 : 41) - (size - 1) / 2 * 19);
        HeatCondition requiredHeat = recipe.heat();
        if (requiredHeat == HeatCondition.NONE) {
            AllGuiTextures.JEI_NO_HEAT_BAR.render(graphics, 4, 80);
            AllGuiTextures.JEI_SHADOW.render(graphics, 81, 68);
        } else {
            AllGuiTextures.JEI_HEAT_BAR.render(graphics, 4, 80);
            AllGuiTextures.JEI_LIGHT.render(graphics, 81, 88);
            graphics.field_59826.method_70922((class_11256)new BasinBlazeBurnerRenderState(new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), 91, 69, requiredHeat.visualizeAsBlazeBurner()));
        }
        graphics.method_51439(graphics.field_44656.field_1772, (class_2561)CreateLang.translateDirect(requiredHeat.getTranslationKey(), new Object[0]), 9, 86, requiredHeat.getColor(), false);
    }
}

